
class LANG:
    # more langs here: https://arc.yandex-team.ru/wsvn/arc/trunk/arcadia//library/langs/langs.h
    LANG_UNK = 0  # Unknown
    LANG_RUS = 1  # Russian
    LANG_ENG = 2  # English
    LANG_POL = 3  # Polish
    LANG_HUN = 4  # Hungarian
    LANG_UKR = 5  # Ukrainian
    LANG_GER = 6  # German
    LANG_FRE = 7  # French
    LANG_TAT = 8  # Tatar
    LANG_BEL = 9  # Belarusian
    LANG_KAZ = 10  # Kazakh


class SaasAnnRegion(object):
    def __init__(self, region, streams):
        """
        :type region: int
        :param streams: {stream_name: encoded_stream_data}
        :type streams: dict
        """
        self.region = region
        self.streams = streams

    def to_json(self):
        return {'region': self.region, 'streams': self.streams}


class SaasAnnotation(object):
    __slots__ = ('text', 'lang', 'regions')

    def __init__(self, text, lang, regions):
        """
        :type lang: int
        :param regions: list of SaasAnnRegion objects
        :type regions: list
        """
        self.text = text
        self.lang = lang
        self.regions = regions

    def to_json(self, context):
        return {'text': context.serialize_text(self.text), 'lang': self.lang, 'regions': [r.to_json() for r in self.regions]}
