class ToJsonContext:
    class TYPE:
        json = 'json'
        json_ref = 'json_ref'

    __slots__ = ['parts', 'MAX_TEXT_LENGTH_NO_REF']

    def __init__(self, serialize_type=TYPE.json):
        self.parts = {}
        self.MAX_TEXT_LENGTH_NO_REF = 512 if serialize_type == self.TYPE.json_ref else (1 << 32)

    def serialize_text(self, value):
        if isinstance(value, str):
            if value.__len__() <= self.MAX_TEXT_LENGTH_NO_REF:
                return value
            else:
                result = '$attr{}'.format(self.parts.__len__())
                self.parts[result] = value
                return result
        elif isinstance(value, list):
            return [self.serialize_text(v) for v in value]
        elif isinstance(value, dict):
            return {k: self.serialize_text(v) for k, v in value.items()}
        else:
            return value
