from .document import SaasDocument


class ACT:
    modify = 'modify'
    add = 'add'
    update = 'update'
    delete = 'delete'


class SaasMessage(object):

    Document = None
    Prefix = None
    Action = None

    Request = None

    def __init__(self, action=ACT.modify, prefix=0, document=None):
        self.Action = action
        self.Prefix = prefix
        self.Document = document

    def set_document(self, document):
        self.Document = document

    def gen_document(self, **kwargs):
        self.Document = SaasDocument(**kwargs)

    def to_json(self, context):
        json_repr = dict()
        json_repr['action'] = self.Action
        if self.Prefix is not None:
            json_repr['prefix'] = self.Prefix
        if self.Request is not None:
            json_repr['request'] = self.Request

        if self.Document:
            json_repr['docs'] = [self.Document.to_json(context)]
        return json_repr
