from cluster import run_cluster
from test_common import run_some_test
from test_common import run_attr_test
from test_common import run_kv_test
from test_common import run_zone_test
from test_common import run_ann_test
from test_common import run_deletion_test
from test_common import run_special_deletion_test


def run_test(testclass, prefixed=False):
    ports = run_cluster(prefixed, test_name=testclass.__name__ + ('_kon' if prefixed else '_koff'))
    sport, iport = ports['search_port'], ports['indexer_port']
    res = testclass('http://localhost:' + str(iport) + '/service/bfc0e42a74f3d19b8bb8e0fc9c620055',
                    'http://localhost:' + str(sport),
                    prefixed)
    ports['process'].kill()
    assert res


def test_mini():
    run_test(run_some_test, False)


def test_mini_kon():
    run_test(run_some_test, True)


def test_attrs():
    run_test(run_attr_test, False)


def test_kv_keys():
    run_test(run_kv_test, False)


def test_kv_keys_kon():
    run_test(run_kv_test, True)


def test_zones():
    run_test(run_zone_test, True)


def test_ann():
    run_test(run_ann_test, False)


def test_delete():
    run_test(run_deletion_test, False)


def test_delete_kon():
    run_test(run_deletion_test, True)


def test_delete_special():
    run_test(run_special_deletion_test, False)


def test_delete_special_kon():
    run_test(run_special_deletion_test, True)
