#pragma once

#include "sloth.h"
#include "client.h"
#include <saas/api/action.h>
#include <library/cpp/binsaver/bin_saver.h>
#include <util/thread/pool.h>

namespace NSaas {

    struct TMultithreadIndexerOption {
        TString Host;
        ui16 Port = 0;
        TString IndexKey;
        TString RtyIndexAdapter = "json";
        ui32 ReindexAttemptions = 1;
        ui32 LogLevel = 6;
        ui32 Threads = 1;
        ui32 QueueSize = 0;
        bool Blocking = true;
        TDuration MinSleepDuration = TDuration::MilliSeconds(10);
        TDuration MaxSleepDuration = TDuration::Seconds(10);
        TSendParams SendParams;

        TMultithreadIndexerOption() {}

        TMultithreadIndexerOption(const TString& host, ui16 port, const TString& key)
            : Host(host)
            , Port(port)
            , IndexKey(key)
        {}

        TString GetIndexUrl() const {
            return "/service/" + IndexKey;
        }

        SAVELOAD(Host, Port, IndexKey, RtyIndexAdapter,
            ReindexAttemptions, LogLevel, Threads, QueueSize, Blocking, MinSleepDuration, MaxSleepDuration)
        Y_SAVELOAD_DEFINE(Host, Port, IndexKey, RtyIndexAdapter,
            ReindexAttemptions, LogLevel, Threads, QueueSize, Blocking, MinSleepDuration, MaxSleepDuration)
    };

    class TMultithreadIndexer {
    public:
        using TResultCallback = std::function<void(const NSaas::TSendResult&, const TAction& action)>;
        TMultithreadIndexer(const TMultithreadIndexerOption& options);
        void IndexDocument(TAtomicSharedPtr<TAction> action, TResultCallback resultCb);

    private:
        TMultithreadIndexerOption Options;
        TIndexingClient Client;
        TSlothExp Sloth;
        THolder<IThreadPool> Queue;
    };

}
