#include <saas/api/mr_client/processors/processors.h>
#include <saas/library/erasure/erasure.h>
#include <saas/protos/rtyserver.pb.h>

#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/digest/crc32c/crc32c.h>
#include <util/stream/buffer.h>

Y_UNIT_TEST_SUITE(TSimpleErasureActionProcessor) {
    Y_UNIT_TEST(JustWorks) {
        // Constructing node...
        auto node = NYT::TNode()("key", "Simple key")("value", "Just simple and small value");
        // Defining processors...
        auto rowProcessor = NSaas::IRowProcessor::TFactory::Construct("simple", NSaas::TRowProcessorOptions());
        auto erasuredRowProcessor = NSaas::TRowDecoratorFactory::Construct("simple_erasure03+02", NSaas::TRowProcessorOptions());
        // Checking validity...
        auto action = rowProcessor->ProcessRowSingle(node);
        TString serialization;
        Y_PROTOBUF_SUPPRESS_NODISCARD action.ToProtobuf().SerializeToString(&serialization);

        auto actions = erasuredRowProcessor->ProcessRow(node);
        TVector<NSaas::TErasurePart> parts(actions.size());
        for (ui32 i = 0; i < actions.size(); ++i) {
            auto message = actions[i].MutableProtobuf();
            auto body = message.GetDocument().GetBody();
            Y_PROTOBUF_SUPPRESS_NODISCARD parts[i].ParseFromString(body);
        }

        NSaas::TErasureHelper erasure;

        UNIT_ASSERT_EQUAL(serialization, erasure.Merge(parts));
    }
}