#include "action.h"
#include "serialize.h"

#include <saas/api/action.h>

NSaas::TActionPtr NSaas::AddDocument(const TString& url, const NOxygen::TObjectContext& objectContext, const TActionInfo& info) {
    auto result = MakeAtomicShared<NSaas::TAction>();
    auto& document = result->GetDocument();
    document.SetUrl(url);
    document.SetTimestamp(info.Timestamp);
    document.SetVersion(info.Version);
    document.SetStreamId(info.Stream);
    document.AddExtraTimestamp(
        info.Stream + 1,
        (static_cast<ui64>(info.TableTimestamp) << 32) + info.Record
    );
    document.AddObjectContext(NOxygen::Serialize(objectContext));

    return result;
}

NSaas::TActionPtr NSaas::DeleteDocument(const TString& url, const TActionInfo& info) {
    auto result = MakeAtomicShared<NSaas::TAction>();
    auto& document = result->GetDocument();

    result->SetActionType(NSaas::TAction::atDelete);
    document.SetUrl(url);
    document.SetTimestamp(info.Timestamp);
    document.SetVersion(info.Version);

    return result;
}
