#pragma once

#include <util/generic/fwd.h>
#include <util/generic/ptr.h>

namespace NOxygen {
    class TObjectContext;
}

namespace NSaas {
    class TAction;
    using TActionPtr = TAtomicSharedPtr<TAction>;

    struct TActionInfo {
        ui32 Version = 0;
        ui32 Timestamp = 0;
        ui32 Stream = 0;
        ui32 TableTimestamp = 0;
        ui32 Record = 0;
    };

    TActionPtr AddDocument(const TString& url, const NOxygen::TObjectContext& objectContext, const TActionInfo& info);
    TActionPtr DeleteDocument(const TString& url, const TActionInfo& info);
}
