#include "serialize.h"

#include <robot/library/oxygen/indexer/object_context/object_context.h>
#include <robot/library/oxygen/indexer/tuple_value/tuple_value.h>

TString NOxygen::Serialize(const NOxygen::TObjectContext& objectContext) {
    TStringStream ss;
    for (auto&& attr : objectContext) {
        const auto tupleValue = NOxygen::ConvertToTupleValue(attr);
        const auto tuple = tupleValue->GetTuple();
        const ui32 size = tuple->SizeOfAligned();

        ss.Write(tuple, size);
    }

    return ss.Str();
}
