#include <saas/api/querydata/saas_document.h>

int main() {
    NQueryDataSaaS::TQDSaaSInputRecord record;
    record.SetSubkey_Url("http://example.com");
    record.SetData_JSON("{\"key\": 42}");

    NSaas::TQueryDataMessageBuilder builder;
    builder.Add("test_namespace", TInstant::Now(), record);

    Cout << builder.BuildProto().Utf8DebugString() << '\n';

    // generate 'delete' message
    NQueryDataSaaS::TQDSaaSInputRecord delRecord;
    delRecord.SetSubkey_Url("http://example.com");
    delRecord.SetDelete(true);

    builder.Clear();
    builder.Add("test_namespace", TInstant::Now(), delRecord);

    Cout << builder.BuildProto().Utf8DebugString() << '\n';

    return 0;
}


