#pragma once

#include <kernel/querydata/saas/qd_saas_key.h>
#include <kernel/querydata/saas_yt/idl/qd_saas_input_record.pb.h>

#include <saas/api/action.h>
#include <saas/protos/rtyserver.pb.h>

#include <library/cpp/json/writer/json_value.h>

#include <util/datetime/base.h>

namespace NSaas {
    struct TQueryDataMessageBuilder {
        using TKeyOrder = TVector<NQueryDataSaaS::ESaaSSubkeyType>;

        TQueryDataMessageBuilder();
        ~TQueryDataMessageBuilder();

        void Clear();
        void Add(const TString& ns, TInstant timestamp, const NQueryDataSaaS::TQDSaaSInputRecord& record, const TKeyOrder* customKeyOrder = nullptr);

        TAction BuildAction() const;
        NRTYServer::TMessage BuildProto() const;
        NJson::TJsonValue BuildJson() const;

    private:
        struct TPrivate;
        THolder<TPrivate> P;
    };
}

