#include "grouping.h"
#include <library/cpp/logger/global/global.h>
#include <util/stream/str.h>

namespace NSaas {

    TString TSortPolicy::ToString() const {
        switch (SortMethod) {
                case smRelev:
                    return "rlv";
                    break;
                case smTime:
                    return "tm";
                    break;
                case smPr:
                    return "pr";
                    break;
                case smShuffle:
                    return "shuffle";
                    break;
                case smAttr:
                    Y_ENSURE(!!AttrName, yexception() << "Incorrect sort attr name");
                    return AttrName;
                    break;
                default:
                    Y_ENSURE(false, yexception() << "Incorrect sort method docs in group");
        }
        return "rlv";
    }

    TString TGrouping::GetQuery() const {
        TStringStream result;
        result << (int)Type;

        Y_ENSURE(!!AttrName ^ (Type == gtFlat), yexception() << "Incorrect AttrName");
        result << "." << AttrName;

        Y_ENSURE(GroupsCount > 0, yexception() << "Incorrect GroupsCount");
        result << "." << GroupsCount;

        Y_ENSURE(DocsCount > 0, yexception() << "Incorrect DocsCount");
        result << "." << DocsCount;

        result << "." << CurCat;
        result << "." << Depth;
        result << "." << (int)KillDupPolicy;
        result << "." << DeepSelGroup;
        result << "." << SortMethodInGroup.ToString();
        if (Ascending)
            result << ".1";
        else
            result << ".0";

        if (SortMethodGroups == smgRelevFirst)
            result << ".";
        else if (SortMethodGroups == smgCount)
            result << ".count";
        else
            Y_ENSURE(false, yexception() << "Incorrect SortMethodGroup");

        result << "." << DupGroupSize;
        result << "." << MaxDupGroupCount;
        return result.Str();
    }

}
