#pragma once

#include <util/generic/string.h>

namespace NSaas {

    class TSortPolicy {
    public:
        enum TSortMethod {smRelev, smTime, smPr, smShuffle, smAttr};
    protected:
        TString AttrName;
        TSortMethod SortMethod;
    public:

        TSortPolicy& SetAttrName(const TString& Value) {
            AttrName = Value;
            return *this;
        }

        TSortPolicy& SetSortMethod(TSortMethod Value) {
            SortMethod = Value;
            return *this;
        }

        TSortPolicy()
            : AttrName("")
            , SortMethod(smRelev){

        }

        TString ToString() const;
    };

    //deserialization: search/grouping/groupinfo.h TGroupingParams
    class TGrouping {
    public:
        enum TGroupingType {gtFlat, gtDeep, gtWide};
        enum TKillDupPolicy {kdpNoAct, kdpRemainFirstOnly, kdpIgnoreDocInDoubleCateg, kdpOneDocOnceInCateg};
        enum TSortMethodGroups {smgRelevFirst, smgCount};
    private:
        TString AttrName;
        TGroupingType Type;
        ui32 DocsCount;
        ui32 GroupsCount;
        int Depth;
        TKillDupPolicy KillDupPolicy;
        int DeepSelGroup;
        TSortMethodGroups SortMethodGroups;
        TSortPolicy SortMethodInGroup;
        TString SortAttrName;
        bool Ascending;
        int CurCat;
        ui32 MaxDupGroupCount;
        ui32 DupGroupSize;
    public:

        TGrouping()
            : AttrName("")
            , Type(gtFlat)
            , DocsCount(1)
            , GroupsCount(10)
            , Depth(0)
            , KillDupPolicy(kdpNoAct)
            , DeepSelGroup(-1)
            , SortMethodGroups(smgRelevFirst)
            , SortAttrName("")
            , Ascending(false)
            , CurCat(-1)
            , MaxDupGroupCount(0)
            , DupGroupSize(0){

        }

        TGrouping& SetAttrName(TString Value) {
            AttrName = Value;
            return *this;
        };

        TSortPolicy& SortMethodInGroupBuilder() {
            return SortMethodInGroup;
        }

        TGrouping& SetType(TGroupingType Value) {
            Type = Value;
            return *this;
        };

        TGrouping& SetGroupsCount(ui32 Value) {
            GroupsCount = Value;
            return *this;
        };

        TGrouping& SetDocsCount(ui32 Value) {
            DocsCount = Value;
            return *this;
        };

        TGrouping& SetCurCat(int Value) {
            CurCat = Value;
            return *this;
        };

        TGrouping& SetDepth(int Value) {
            Depth = Value;
            return *this;
        };

        TGrouping& SetKillDup(TKillDupPolicy Value) {
            KillDupPolicy = Value;
            return *this;
        };

        TGrouping& SetDeepSelGroup(int Value) {
            DeepSelGroup = Value;
            return *this;
        };

        TGrouping& SetSortMethodGroups(TSortMethodGroups Value) {
            SortMethodGroups = Value;
            return *this;
        };

        TGrouping& SetAscending(bool Value) {
            Ascending = Value;
            return *this;
        };

        TGrouping& SetDupGroupSize(ui32 Value) {
            DupGroupSize = Value;
            return *this;
        };

        TGrouping& SetMaxDupGroupCount(ui32 Value) {
            MaxDupGroupCount = Value;
            return *this;
        };

        TString GetQuery() const;

    };


}
