#include "tvm.h"

namespace NSaas {

    std::shared_ptr<TTvmManager> TTvmManager::CreateWithTvmApi(
        const TString& secret, ui32 srcId, ui32 dstId, const TString& diskCacheDir,
        TIntrusivePtr<NTvmAuth::ILogger> logger)
    {
        NTvmAuth::NTvmApi::TClientSettings settings;
        settings.SetSelfTvmId(srcId);
        settings.EnableServiceTicketsFetchOptions(secret, NTvmAuth::NTvmApi::TClientSettings::TDstVector{dstId});
        settings.SetDiskCacheDir(diskCacheDir);
        auto tvmClient = std::make_shared<NTvmAuth::TTvmClient>(settings, logger);

        return std::make_shared<TTvmManager>(std::move(tvmClient), dstId);
    }

    std::shared_ptr<TTvmManager> TTvmManager::CreateWithTvmTool(
        const NTvmAuth::NTvmTool::TClientSettings& settings,
        NTvmAuth::TTvmId dstId,
        TIntrusivePtr<NTvmAuth::ILogger> logger)
    {
        auto tvmClient = std::make_shared<NTvmAuth::TTvmClient>(settings, logger);
        return std::make_shared<TTvmManager>(std::move(tvmClient), dstId);
    }

    std::shared_ptr<TTvmManager> TTvmManager::CreateWithTvmClient(
        std::shared_ptr<NTvmAuth::TTvmClient> tvmClient,
        NTvmAuth::TTvmId dstId)
    {
        Y_ENSURE(tvmClient, "NTvmAuth::TvmClient is null");
        return std::make_shared<TTvmManager>(std::move(tvmClient), dstId);
    }
}
