#pragma once

#include <library/cpp/tvmauth/client/facade.h>

namespace NSaas {

    constexpr TStringBuf HEADER_X_YA_SERVICE_TICKET = "X-Ya-Service-Ticket";

    class TTvmManager {
    private:
        std::shared_ptr<NTvmAuth::TTvmClient> TvmClient;
        NTvmAuth::TTvmId DstId;

    public:
        TTvmManager(std::shared_ptr<NTvmAuth::TTvmClient> tvmClient, NTvmAuth::TTvmId dstId)
            : TvmClient(std::move(tvmClient))
            , DstId(dstId)
        {}

        TString GetTicket() const {
            Y_ENSURE(TvmClient, "NTvmAuth::TvmClient is null");
            return TvmClient->GetServiceTicketFor(DstId);
        }

        static std::shared_ptr<TTvmManager> CreateWithTvmApi(
            const TString& secret, ui32 srcId, ui32 dstId, const TString& diskCacheDir,
            TIntrusivePtr<NTvmAuth::ILogger> logger);

        static std::shared_ptr<TTvmManager> CreateWithTvmTool(
            const NTvmAuth::NTvmTool::TClientSettings& settings,
            NTvmAuth::TTvmId dstId,
            TIntrusivePtr<NTvmAuth::ILogger> logger);

        static std::shared_ptr<TTvmManager> CreateWithTvmClient(
            std::shared_ptr<NTvmAuth::TTvmClient> tvmClient,
            NTvmAuth::TTvmId dstId);
    };
}
