#include "interface.h"
#include "saas_send.h"
#include "pq_send.h"

namespace NCommonProxy {

    ISaasSendingClient::ISaasSendingClient(const TString& name)
        : Name(name)
    {}

    THolder<NCommonProxy::ISaasSendingClient> ISaasSendingClient::Create(const TString& name,
                                                                         const TSenderConfig& sender,
                                                                         const TPQSenderConfig& pqSender,
                                                                         const NSaas::TCheckMessageSettings& checkMessage) {
        if (sender.SendType == "pq") {
            return MakeHolder<TPQSaasSendingClient>(name, pqSender, checkMessage);
        } else {
            return MakeHolder<TSaasSendingClient>(name, sender);
        }
    }

    ISaasSendingClient::TSendResult::TSendResult(bool success, const TString& comment)
        : Success(success)
        , Comment(comment)
    {}
}
