#pragma once

#include "interface.h"
#include <saas/api/action.h>
#include <library/cpp/unistat/unistat.h>
#include <kernel/common_proxy/common/replier.h>
#include <saas/common_proxy/lib/configs/sender.h>
#include <saas/common_proxy/lib/configs/pq_sender.h>
#include <saas/library/check_message/check_message.h>

namespace NCommonProxy {
    class ISaasSendingClient {
    public:
        struct TSendResult {
            TSendResult(bool success, const TString& comment);

            bool Success;
            TString Comment;
        };

    public:
        ISaasSendingClient(const TString& name);
        virtual ~ISaasSendingClient() = default;
        virtual void Start() = 0;
        virtual void Stop() = 0;
        virtual void Wait() const = 0;
        virtual void Send(const NSaas::TAction& action, IReplier::TPtr replier) const = 0;
        virtual TSendResult Send(const NSaas::TAction& action) const = 0;
        virtual void RegisterSignals(TUnistat& tass) const = 0;
        virtual void UpdateUnistatSignals() const = 0;
        virtual ui32 GetInFly() const = 0;
        static THolder<ISaasSendingClient> Create(const TString& name,
                                                  const TSenderConfig& sender,
                                                  const TPQSenderConfig& pqSender,
                                                  const NSaas::TCheckMessageSettings& checkMessage);
    protected:
        const TString Name;
    };
}
