#pragma once

#include "interface.h"
#include <saas/common_proxy/lib/configs/pq_sender.h>
#include <saas/library/check_message/check_message.h>
#include <library/cpp/logger/log.h>
#include <util/thread/pool.h>

namespace NCommonProxy {
    class TPQSaasSendingClient : public ISaasSendingClient {
    public:
        TPQSaasSendingClient(const TString& name, const TPQSenderConfig& config, const NSaas::TCheckMessageSettings& checkMessage);
        ~TPQSaasSendingClient();
        void Start() override;
        void Stop() override;
        void Wait() const override;
        void Send(const NSaas::TAction& action, IReplier::TPtr replier) const override;
        TSendResult Send(const NSaas::TAction& action) const override;
        void RegisterSignals(TUnistat& tass) const override;
        void UpdateUnistatSignals() const override;

        ui32 GetInFly() const override;

    private:
        class TWriter;

    private:
        const TPQSenderConfig Config;
        const NSaas::TCheckMessageSettings CheckMessageSettings;
        TLog Logger;
        THolder<TWriter> Writer;
    };
}

