#pragma once

#include "interface.h"
#include <saas/common_proxy/lib/configs/sender.h>
#include <saas/library/sender_neh/sender_neh.h>
#include <saas/api/indexing_client/client.h>

namespace NCommonProxy {
    class TSaasSendingClient : public ISaasSendingClient {
    public:
        TSaasSendingClient(const TString& name, const TSenderConfig& config);
        void Start() override;
        void Stop() override;
        void Wait() const override;
        void Send(const NSaas::TAction& action, IReplier::TPtr replier) const override;
        TSendResult Send(const NSaas::TAction& action) const override;
        void RegisterSignals(TUnistat& tass) const override;
        void UpdateUnistatSignals() const override;

        ui32 GetInFly() const override;

    private:
        const TSenderConfig Config;
        TString NehAddress;

        NSaas::TIndexingClient IndexingClient;
        mutable NRTYServer::TMultiRequesterBase NehRequester;
        mutable TAtomic InFly = 0;
    };
}
