#include <saas/common_proxy/lib/configs/pq_sender.h>
#include <util/generic/yexception.h>
#include <util/string/vector.h>
#include <util/string/split.h>

NCommonProxy::TPQSenderConfig::TPQSenderConfig()
    : Sharding(NSaas::External)
{}

void NCommonProxy::TPQSenderConfig::Init(const TYandexConfig::Section& section) {
    const TYandexConfig::Directives& dir = section.GetDirectives();
    dir.GetValue("PQHost", PQHost);
    dir.GetValue("TopicPrefix", Topic);
    dir.GetValue("TVMClientID", TVMClientID);
    dir.GetValue("TVMServerID", TVMServerID);
    dir.GetValue("TVMSecret", TVMSecret);
    dir.GetValue("Log", Log);
    dir.GetValue("LogLevel", LogLevel);
    dir.GetValue("MDSHost", MDSHost);
    dir.GetValue("DMHost", DMHost);
    dir.GetValue("DMPort", DMPort);
    dir.GetValue("CType", CType);
    dir.GetValue("ServiceName", ServiceName);
    dir.GetValue("MaxInFly", MaxInFly);
    dir.GetValue("WriteThreads", WriteThreads);
    dir.GetValue("ShardsFrom", ShardsFrom);
    dir.GetValue("PQLibThreads", PQLibThreads);
    dir.GetValue("PQLibCompressThreads", PQLibCompressThreads);
    dir.GetValue("PQLibGRpcThreads", PQLibGRpcThreads);
    dir.GetValue("SendTimeout", SendTimeout);
    dir.GetValue("DryRun", DryRun);
    if (TString sharding = dir.Value("ShardingType", TString())) {
        Sharding = Sharding.FromString(sharding);
    }
    StringSplitter(dir.Value("Shards", TString())).SplitBySet(", ").SkipEmpty().ParseInto(&Shards);
    if (TString codec = dir.Value("Codec", TString())) {
        const auto* descr = NPersQueueCommon::ECodec_descriptor();
        if (const auto* value = descr->FindValueByName(codec)) {
            Codec = static_cast<NPersQueueCommon::ECodec>(value->number());
        } else {
            ythrow yexception() << "Invalid codec: " << codec;
        }
    }
}

void NCommonProxy::TPQSenderConfig::ToString(IOutputStream& so) const {
    so << "PQHost: " << PQHost << Endl;
    so << "TopicPrefix: " << Topic << Endl;
    so << "TVMClientID: " << TVMClientID << Endl;
    so << "TVMServerID: " << TVMServerID << Endl;
    so << "TVMSecret: " << TVMSecret << Endl;
    so << "Log: " << Log << Endl;
    so << "LogLevel: " << LogLevel << Endl;
    so << "MDSHost: " << MDSHost << Endl;
    so << "DMHost: " << DMHost << Endl;
    so << "DMPort: " << DMPort << Endl;
    so << "CType: " << CType << Endl;
    so << "ServiceName: " << ServiceName << Endl;
    so << "MaxInFly: " << MaxInFly << Endl;
    so << "WriteThreads: " << WriteThreads << Endl;
    so << "ShardsFrom: " << ShardsFrom << Endl;
    so << "PQLibThreads: " << PQLibThreads << Endl;
    so << "PQLibCompressThreads: " << PQLibCompressThreads << Endl;
    so << "PQLibGRpcThreads: " << PQLibGRpcThreads << Endl;
    so << "ShardingType: " << Sharding.ToString() << Endl;
    so << "Shards: " << JoinVectorIntoString(Shards, ", ") << Endl;
    so << "SendTimeout: " << SendTimeout << Endl;
    so << "DryRun: " << DryRun << Endl;
    if (Codec) {
        const auto* descr = NPersQueueCommon::ECodec_descriptor();
        const auto* value = descr->FindValueByNumber(*Codec);
        so << "Codec: " << value->name() << Endl;
    }
}
