#pragma once

#include <saas/api/indexing_client/client.h>
#include <saas/library/sharding/sharding.h>
#include <ydb/public/api/protos/draft/persqueue_common.pb.h>
#include <library/cpp/yconf/conf.h>
#include <util/datetime/base.h>
#include <util/generic/string.h>
#include <util/stream/output.h>

namespace NCommonProxy {
    struct TPQSenderConfig {
        enum class EShardsFrom {
            DM /*"DM"*/,
            CONFIG /*"Config"*/
        };
        ui32 TVMClientID = 0;
        ui32 TVMServerID = 2001059;
        TString TVMSecret;
        TString PQHost;
        TString Topic;
        TString Log;
        int LogLevel = 6;
        EShardsFrom ShardsFrom = EShardsFrom::DM;
        TString DMHost = "saas-dm-proxy.n.yandex-team.ru";
        ui16 DMPort = 80;
        TString MDSHost = "saas-searchmap.s3.mds.yandex.net";
        TString CType;
        TString ServiceName;
        NSaas::TShardsDispatcher::TContext Sharding;
        TVector<NSearchMapParser::TShardsInterval> Shards;
        ui32 MaxInFly = 10000;
        ui32 WriteThreads = 10;
        ui32 PQLibThreads = 1;
        ui32 PQLibCompressThreads = 2;
        ui32 PQLibGRpcThreads = 1;
        TDuration SendTimeout = TDuration::Minutes(1);
        bool DryRun = false;
        TMaybe<NPersQueueCommon::ECodec> Codec;

        TPQSenderConfig();
        void Init(const TYandexConfig::Section& section);
        void ToString(IOutputStream& so) const;
    };
}
