#include <saas/common_proxy/lib/configs/searcher.h>

#include <util/string/join.h>

void NCommonProxy::TSearcherConfig::Init(const TYandexConfig::Section& section) {
    const TYandexConfig::Directives& dir = section.GetDirectives();
    if (!dir.GetValue("Service", Service))
        ythrow yexception() << "Cannot create Searcher: set Service";
    if (!dir.GetValue("Host", Host))
        ythrow yexception() << "Cannot create Searcher: set Host";
    if (!dir.GetValue("Port", Port))
        ythrow yexception() << "Cannot create Searcher: set Port";
    dir.GetValue("Timeout", Timeout);
    dir.GetValue("BalancerTimeout", BalancerTimeout);
    dir.GetValue("Attemps", Attemps);
    dir.TryFillArray("ResendDurations", ResendDurations);
    dir.GetValue("MaxInFly", MaxInFly);
    dir.GetValue("Threads", Threads);
    dir.GetValue("TVMClientID", TVMClientID);
    dir.GetValue("TVMServerID", TVMServerID);
    dir.GetValue("TVMSecret", TVMSecret);
    dir.GetValue("TVMCacheDir", TVMCacheDir);
    dir.GetValue("Log", Log);
    dir.GetValue("LogLevel", LogLevel);
}

void NCommonProxy::TSearcherConfig::ToString(IOutputStream& so) const {
    so << "Host: " << Host << Endl;
    so << "Port: " << Port << Endl;
    so << "Service: " << Service << Endl;
    so << "Timeout: " << Timeout << Endl;
    so << "BalancerTimeout: " << BalancerTimeout << Endl;
    so << "Attemps: " << Attemps << Endl;
    so << "ResendDurations: " << JoinSeq(", ", ResendDurations) << Endl;
    so << "MaxInFly: " << MaxInFly << Endl;
    so << "Threads: " << Threads << Endl;
    so << "TVMClientID: " << TVMClientID << Endl;
    so << "TVMServerID: " << TVMServerID << Endl;
    so << "TVMSecret presence: " << bool(TVMSecret) << Endl;
    so << "TVMCacheDir: " << TVMCacheDir << Endl;
    so << "Log: " << Log << Endl;
    so << "LogLevel: " << LogLevel << Endl;
}

bool NCommonProxy::TSearcherConfig::IsTvmConfigured() const {
    return TVMClientID && TVMServerID && TVMSecret && TVMCacheDir && Log;
};
