#pragma once

#include <library/cpp/yconf/conf.h>
#include <util/generic/string.h>
#include <util/generic/vector.h>
#include <util/datetime/base.h>
#include <util/stream/output.h>

namespace NCommonProxy {
    struct TSearcherConfig {
        TString Host;
        ui16 Port = 0;
        TString Service;
        ui32 Attemps = 3;
        ui32 TVMClientID = 0;
        ui32 TVMServerID = 0;
        TString TVMSecret;
        TString TVMCacheDir;
        TString Log;
        int LogLevel = 6;
        TVector<TDuration> ResendDurations;
        ui32 MaxInFly = 10000;
        ui32 Threads = 5;
        TDuration Timeout = TDuration::Seconds(1);
        TDuration BalancerTimeout = TDuration::MilliSeconds(130);
        void Init(const TYandexConfig::Section& section);
        void ToString(IOutputStream& so) const;
        bool IsTvmConfigured() const;
    };
}
