#pragma once

#include <saas/api/indexing_client/client.h>
#include <library/cpp/yconf/conf.h>
#include <util/datetime/base.h>
#include <util/generic/string.h>
#include <util/stream/output.h>

namespace NCommonProxy {
    struct TSenderConfig {
        NSaas::TSendParams SendParams;
        TString SendType;
        TString Host;
        ui16 Port = 0;
        TString Url;
        TDuration Timeout;
        ui32 AttemptsCount = 5;
        ui32 AsyncSendThreads = 1;
        i64 MaxInFly = 10000;
        TVector<TDuration> ResendDurations;

        void Init(const TYandexConfig::Section& section);
        void ToString(IOutputStream& so) const;
    };
}
