#pragma once

#include <kernel/common_proxy/common/sender.h>
#include <saas/api/indexing_client/client.h>
#include <saas/library/check_message/check_message.h>
#include <saas/library/sender_neh/sender_neh.h>
#include <saas/common_proxy/lib/configs/sender.h>
#include <saas/common_proxy/lib/configs/pq_sender.h>
#include <saas/common_proxy/lib/client/interface.h>
#include <saas/common_proxy/lib/saas_action/saas_action.h>

namespace NCommonProxy {

    class TSaasApiSender : public TSender {
    public:
        class TConfig : public TProcessorConfig {
        public:
            enum class EPrefixFilterStyle {
                All /*"all"*/,
                PrefixedOnly /*"prefixed_only"*/,
                NotPrefixedOnly /*"not_prefixed_only"*/
            };
            using TProcessorConfig::TProcessorConfig;
            TSenderConfig Sender;
            TPQSenderConfig PQSender;
            NSaas::TCheckMessageSettings CheckMessage;
            TString DocFieldName;
            EPrefixFilterStyle PrefixFilter = EPrefixFilterStyle::All;
            static TProcessorConfig::TFactory::TRegistrator<TConfig> Registrator;

        protected:
            virtual bool DoCheck() const override;
            virtual void DoInit(const TYandexConfig::Section& componentSection) override;
            virtual void DoToString(IOutputStream& so) const  override;
        };

    public:
        TSaasApiSender(const TString& name, const TProcessorsConfigs& configs);
        virtual void DoStart() override;
        virtual void DoStop() override;
        virtual void DoWait() override;

        virtual const TMetaData& GetInputMetaData() const override;
        virtual const TMetaData& GetOutputMetaData() const override;

        static TProcessor::TFactory::TRegistrator<TSaasApiSender> Registarar;

    protected:
        virtual void DoProcess(TDataSet::TPtr input, IReplier::TPtr replier) const override;
        virtual void CollectInfo(NJson::TJsonValue& result) const override;
        virtual void UpdateUnistatSignals() const override;
        virtual void DoRegisterSignals(TUnistat& tass) const override;
        virtual void AddRequester(TLink::TPtr link) override;

    private:
        class TMustBeSetFieldFilter;
        const TConfig& Config;
        TSaasActionMeta InputMeta;

    protected:
        THolder<ISaasSendingClient> Sender;
    };

}
