#pragma once

#include <library/cpp/http/misc/httpreqdata.h>
#include <library/cpp/mediator/messenger.h>

#include <util/memory/blob.h>

class TDebugMessageAfterSaveClusterTask: public IMessage {
private:
public:
};

class TDebugMessageStartRequestProcessing : public IMessage {
public:
    TDebugMessageStartRequestProcessing (const TString& command, const TServerRequestData& rd, const TBlob& postBuf);
    const TString& GetCommand() const;
    const TServerRequestData& GetRD() const;
    const TBlob& GetPostBuf() const;

private:
    const TString& Command;
    const TServerRequestData& RD;
    const TBlob& Buf;
};

class TDebugMessageDoBuildTaskProcessing : public IMessage {
public:
    TDebugMessageDoBuildTaskProcessing(const TString& taskType);
    const TString& GetTaskType() const;
private:
    TString TaskType;
};
