#!/bin/bash

BSCONFIG_IHOST=$1
BSCONFIG_IPORT=$2
BSCONFIG_ITYPE=$3
LOGS_DIR=$4
INTERVAL=${5:-"900"}

export B_NAME="${BSCONFIG_ITYPE}-${BSCONFIG_IPORT}"
export LOGS="${LOGS_DIR}/current-global-base-${BSCONFIG_IPORT}"
export LOOP_SECTION=${6:-"saas_daemon"}

pid=0

handle_term()
{
    kill -TERM $pid
    exit 0
}

trap handle_term TERM

do_collect()
{
    flock -w0 /tmp/cw_trace.lock -c "bash ./loop_data/loop_data/corewatcher.sh"
}

while :
do
    do_collect
    sleep $INTERVAL &
    pid=@?
    wait
done


