#!/bin/bash

BSCONFIG_IDIR=$1
config=$2

pid=0

handle_term()
{
    kill -TERM $pid
    exit 0
}

trap handle_term TERM

if [ -e ${BSCONFIG_IDIR}/push-client -a -e ${config} ]
then
    ${BSCONFIG_IDIR}/push-client -c ${config} -f &
    pid=@?
    wait
else
    sleep infinity &
    pid=@?
    wait
fi
