#include "cache_module.h"

namespace NRTYDeploy {

    TCacheModule::ICache* TCacheModule::GetCache(const TString& name, const TCacheModule::ICacheCreator& creator) {
        {
            TReadGuard rg(RWMutex);
            const auto& it = Caches.find(name);
            if (it != Caches.end()) {
                return it->second.Get();
            }
        }
        TWriteGuard wg(RWMutex);
            const auto& it = Caches.find(name);
            if (it != Caches.end()) {
                return it->second.Get();
            }
            THolder<ICache> cacheHolder = creator.CreateCache();
            ICache* ptr = cacheHolder.Get();
            Caches[name] = std::move(cacheHolder);
            return ptr;
    }
}
