#pragma once

#include <util/system/rwlock.h>

#include <util/generic/hash.h>


namespace NRTYDeploy {

    class TCacheModule {
    public:
        struct ICache {
            virtual ~ICache() = default;
        };

        struct ICacheCreator {
            virtual ~ICacheCreator() = default;
            virtual THolder<ICache> CreateCache() const = 0;
        };

        ICache* GetCache(const TString& name, const ICacheCreator& creator);

    private:
        TRWMutex RWMutex;
        THashMap<TString, THolder<ICache>> Caches;
    };
}
