#pragma once

#include <library/cpp/json/json_writer.h>
#include <util/generic/map.h>

class TAlertLimits {
private:
    double Warn;
    double Crit;
    ui16 Avgsec;
public:
    TAlertLimits(const double warn, const double crit, const ui16 avgsec);
    NJson::TJsonValue ToJson() const;
};

class TYasmAlert {
private:
    TString GolovanId;
    TString Signal;
    TMap<TString, TString> RealTags;
    TAlertLimits Limits;
    TString Descr;
public:
    TYasmAlert(const TString& golovanId, const TString& signal, const TString& itype);
    TYasmAlert& SetLimits(const double warn, const double crit, const ui16 avgsec);
    TYasmAlert& AddRealTag(const TString& tagName, const TString& tagValue);
    const TString& GetId() const {
        return GolovanId;
    }
    TString ToString() const;
    NJson::TJsonValue ToJson() const;
};

class TExistingAlert {
private:
    const NJson::TJsonValue Json;
    TString Service;
    TString Ctype;
    TString AKey;
public:
    TExistingAlert(const NJson::TJsonValue& json, const TString& alertsPrefix);
    const TString& GetCtype() const {
        return Ctype;
    }
    const TString& GetService() const {
        return Service;
    }
    const TString& GetName() const {
        return Json["name"].GetString();
    }
    const TString& GetAKey() const {
        return AKey;
    }
    const TString& GetSignal() const {
        return Json["signal"].GetString();
    }
    bool GetLimits(double& warn, double& crit, ui16& avgsec, TString& message) const;
};
