#include "format.h"
#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/logger/global/global.h>
#include <library/cpp/json/json_writer.h>

namespace {
    void InitLog() {
        if (!GlobalLogInitialized())
            DoInitGlobalLog("console", 7, false, false);
    }

}

Y_UNIT_TEST_SUITE(TSaasGolovanMessageTest) {
    Y_UNIT_TEST(MsgFormat) {
        InitLog();
        TYasmAlert alert("some_alert_name", "some_signal", "someitype");
        alert.SetLimits(1.67, 4.32, 90);
        NJson::TJsonValue js = alert.ToJson();
        TStringStream ss;
        NJson::WriteJson(&ss, &js);
        INFO_LOG << ss.Str();
        UNIT_ASSERT(js["name"] == "some_alert_name");
        UNIT_ASSERT(js["mgroups"].GetArray().ysize() == 1);
        UNIT_ASSERT(js["mgroups"][0] == "ASEARCH");
        UNIT_ASSERT(js["signal"] == "some_signal");
        UNIT_ASSERT(js["tags"]["itype"] == "someitype");
        UNIT_ASSERT(js["warn"][0] == 1.67);
        UNIT_ASSERT(js["warn"][1] == 4.32);
        UNIT_ASSERT(js["crit"][0] == 4.32);
       // UNIT_ASSERT(js["crit"][1].IsNull());
        UNIT_ASSERT(js["value_modify"]["window"] == 90);

        alert.SetLimits(20, 10, 0);
        js = alert.ToJson();
        TStringStream ss1;
        NJson::WriteJson(&ss1, &js);
        INFO_LOG << ss1.Str();
        UNIT_ASSERT(!js.Has("value_modify"));
        UNIT_ASSERT(js["warn"][0] == 10);
        UNIT_ASSERT(js["warn"][1] == 20);
        UNIT_ASSERT(js["crit"][1] == 10);
        //UNIT_ASSERT(js["crit"][0].IsNull());
    };
}
