#pragma once

#include "format.h"

#include <saas/deploy_manager/config/config.h>
#include <library/cpp/json/json_writer.h>

class TGolovanModule {
private:
    const TDeployManagerConfig::TGolovanConfig GolovanConfig;
    const bool Enabled;
    bool SendGolovanRequest(const TString& query, NJson::TJsonValue& result, const TString& data="");
public:
    TGolovanModule(const TDeployManagerConfig::TAlertsConfig& alertsConfig);
    bool GetAlerts(const TMap<TString, TString>& filter, NJson::TJsonValue& result);
    bool CreateSingleAlert(const TYasmAlert& alert, NJson::TJsonValue& result);
    bool RemoveAlert(const TString& id, NJson::TJsonValue& result);
};
