#pragma once

#include <util/generic/string.h>
#include <util/generic/set.h>
#include <library/cpp/json/json_writer.h>

const TString GOLEM_DEFAULT_PREFIX = "saas_gen";
const TString GOLEM_USERS_HOST_POSTFIX = "_users";
const TString GOLEM_NOCALL_HOST_POSTFIX = "_nc";

class TJugglerCheck {
public:
    class TFlaps {
    private:
        ui32 CriticalTime;
        ui32 StableTime;
        ui32 BoostTime;
    public:
        bool IsOn() const {
            return (CriticalTime > 0 || StableTime > 0 || BoostTime > 0);
        }
        TFlaps(const ui32 criticalTime, const ui32 stableTime, const ui32 boostTime);
        NJson::TJsonValue ToJson() const;
    };

    class TNotifications {
    private:
        TString PhoneGolemTimeStart;
        TString PhoneGolemTimeEnd;
        ui32 CalendarId;
        TSet<TString> CalendarMethods;
        TString PhoneCalendarTimeStart;
        TString PhoneCalendarTimeEnd;

        TVector<TString> Owners;
        TVector<TString> WarnUsers;
        bool SkipGolem;
    public:
        TNotifications(const TString& phoneTimeStart, const TString& phoneTimeEnd,
            const ui32 calendarId, const TSet<TString>& calendarMethods);
        TNotifications& SetGolemTimes(const TString& phoneTimeStart, const TString& phoneTimeEnd);
        TNotifications& SetCalendarTimes(const TString& phoneTimeStart, const TString& phoneTimeEnd);
        TNotifications& SetWarnUsers(const TVector<TString>& users);
        TNotifications& SetOwners(const TVector<TString>& owners);
        TNotifications& SetSkipGolem(const bool skipGolem);
        bool GetSkipGolem() const {
            return SkipGolem;
        }
        NJson::TJsonValue ToJson() const;
    };

private:
    TString SaasService;
    TString Ctype;
    TString AKey;
    bool IsUsers;
    TString CommonTag;
    TString Namespace;
    TString GolemPrefix;
    TFlaps Flaps;
    TString GolovanId;
    TNotifications Notifications;

public:
    TJugglerCheck(const TString& service, const TString& ctype, const TString& aKey,
        const bool isUsers, const TString& commonTag, const TString& nameSpace, const TString& golemPrefix);
    TJugglerCheck& SetFlaps(const ui32 criticalTime, const ui32 stableTime, const ui32 boostTime);
    TJugglerCheck& SetNotifications(const TString& phoneTimeStart, const TString& phoneTimeEnd,
        const ui32 calendarId, const TSet<TString>& calendarMethods);
    TJugglerCheck& SetIsUsers(const bool IsUsers);
    TJugglerCheck& SetGolemTimes(const TString& phoneTimeStart, const TString& phoneTimeEnd);
    TJugglerCheck& SetCalendarTimes(const TString& phoneTimeStart, const TString& phoneTimeEnd);
    TJugglerCheck& SetWarnUsers(const TVector<TString>& users);
    TJugglerCheck& SetOwners(const TVector<TString>& owners);
    TJugglerCheck& SetSkipGolem(const bool skipGolem);
    TJugglerCheck& SetGolovanId(const TString& golovanId);
    TString ToString() const;
    NJson::TJsonValue ToJson() const;
    TString GolemHost() const;
    NJson::TJsonValue Tags() const;
    bool GetSkipGolem() const {
        return Notifications.GetSkipGolem();
    }
};

class TExistingCheck {
private:
    const NJson::TJsonValue Json;
    TString GetTagPart(const TString& tagBeg) const;
public:
    TExistingCheck(const NJson::TJsonValue& json);
    TString GetService() const;
    TString GetCtype() const;
    TString GetAKey() const;
    TString GetIsUsersTag() const;
    bool GetIsUsers() const;
    bool GetHasGolem() const;
    void GetFlaps(ui32& criticalTime, ui32& stableTime, ui32& boostTime) const;
    bool GetGolemTimes(TString& timeStart, TString& timeEnd) const;
    bool GetOwners(TVector<TString>& owners) const;
    bool GetWarnUsers(TVector<TString>& users) const;
};
