#include "format.h"
#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/logger/global/global.h>
#include <library/cpp/json/json_writer.h>

namespace {
    void InitLog() {
        if (!GlobalLogInitialized())
            DoInitGlobalLog("console", 7, false, false);
    }

}

Y_UNIT_TEST_SUITE(TSaasJugglerMessageTest) {
    Y_UNIT_TEST(MsgFormat) {
        InitLog();
        TJugglerCheck check("tests", "testing", "some-key", false, "some_tag", "ns", "some_prefix");
        check.SetFlaps(300, 120, 0).SetGolovanId("alert_name");
        TSet<TString> methods({"sms", "phone", "telegram"});
        check.SetNotifications("12:21", "22:32", 1234567, methods);
        TVector<TString> users({"saas-robot", "robot-saas-duty"});
        check.SetWarnUsers(users).SetOwners(users);
        NJson::TJsonValue flapsCanon(NJson::JSON_MAP);
        flapsCanon["critical_time"] = 300;
        flapsCanon["stable_time"] = 120;
        flapsCanon["boost_time"] = 0;
        NJson::TJsonValue tagsCanon(NJson::JSON_ARRAY);
        tagsCanon.AppendValue("saas_service_tests");
        tagsCanon.AppendValue("saas_ctype_testing");
        tagsCanon.AppendValue("saas_skey_some-key");
        tagsCanon.AppendValue("some_tag");
        tagsCanon.AppendValue("saas_group_dev");
        tagsCanon.AppendValue("saas_golem_on");
        NJson::TJsonValue js = check.ToJson();
        TStringStream ss;
        NJson::WriteJson(&ss, &js);
        INFO_LOG << ss.Str();
        UNIT_ASSERT(js["host"] == "some_prefix_testing_tests");
        UNIT_ASSERT(js["service"] == "saas_testing_tests_some-key");
        UNIT_ASSERT(js["flaps"] == flapsCanon);
        UNIT_ASSERT(js["tags"] == tagsCanon);
        UNIT_ASSERT(js["namespace"] == "ns");
        UNIT_ASSERT(js["children"][0]["service"] == "alert_name");
        UNIT_ASSERT(js["meta"]["urls"][0]["url"] == "https://yasm.yandex-team.ru/alert/alert_name");
        UNIT_ASSERT(js["meta"]["urls"][1]["url"] == "https://saas-mon.n.yandex-team.ru/deploy?ctype=testing&service=tests");
        UNIT_ASSERT(js["notifications"][0]["template_kwargs"]["time_end"] == "22:32");
        UNIT_ASSERT(js["notifications"][0]["template_kwargs"]["time_start"] == "12:21");
        UNIT_ASSERT(js["notifications"][0]["template_kwargs"]["logins"][0] == "saas-robot");
        UNIT_ASSERT(js["notifications"][0]["template_name"] == "phone_escalation");
        UNIT_ASSERT(js["notifications"][1]["template_name"] == "on_status_change");
        UNIT_ASSERT(js["notifications"][1]["template_kwargs"]["time_end"] == "22:32");
        UNIT_ASSERT(js["notifications"][1]["template_kwargs"]["calendar_id"] == 1234567);
        UNIT_ASSERT(js["notifications"][1]["template_kwargs"]["time_start"] == "12:21");
        UNIT_ASSERT(js["notifications"][1]["template_kwargs"]["method"][0] == "phone");
        UNIT_ASSERT(js["notifications"][2]["template_name"] == "on_status_change");
        UNIT_ASSERT(js["notifications"][2]["template_kwargs"]["calendar_id"] == 1234567);
        TSet<TString> noPhoneMethods({"sms", "telegram"});
        TSet<TString> gotMethods;
        for (auto& i : js["notifications"][2]["template_kwargs"]["method"].GetArray()) {
            gotMethods.insert(i.GetString());
        }
        UNIT_ASSERT(noPhoneMethods == gotMethods);
        UNIT_ASSERT(!js["notifications"][2]["template_kwargs"].Has("time_start"));

        UNIT_ASSERT(js["notifications"][3]["template_name"] == "on_status_change");
        UNIT_ASSERT(!js["notifications"][3]["template_kwargs"].Has("calendar_id"));
        UNIT_ASSERT(js["notifications"][3]["template_kwargs"]["status"][0] == "WARN");
        TVector<TString> gotLogins;
        for (auto& i : js["notifications"][3]["template_kwargs"]["login"].GetArray()) {
            gotLogins.push_back(i.GetString());
        }
        UNIT_ASSERT(users == gotLogins);
    };

    Y_UNIT_TEST(MsgNoGolemFormat) {
        InitLog();
        TJugglerCheck check("tests", "testing", "some-key", false, "some_tag", "ns", "some_prefix");
        check.SetFlaps(300, 120, 0).SetGolovanId("alert_name");
        TSet<TString> methods({"sms", "phone", "telegram"});
        check.SetNotifications("12:21", "22:32", 1234567, methods);
        TVector<TString> users({"saas-robot", "robot-saas-duty"});
        check.SetWarnUsers(users).SetSkipGolem(true).SetIsUsers(true);
        NJson::TJsonValue flapsCanon(NJson::JSON_MAP);
        flapsCanon["critical_time"] = 300;
        flapsCanon["stable_time"] = 120;
        flapsCanon["boost_time"] = 0;
        NJson::TJsonValue tagsCanon(NJson::JSON_ARRAY);
        tagsCanon.AppendValue("saas_service_tests");
        tagsCanon.AppendValue("saas_ctype_testing");
        tagsCanon.AppendValue("saas_skey_some-key");
        tagsCanon.AppendValue("some_tag");
        tagsCanon.AppendValue("saas_group_users");
        tagsCanon.AppendValue("saas_golem_off");
        NJson::TJsonValue js = check.ToJson();
        TStringStream ss;
        NJson::WriteJson(&ss, &js);
        INFO_LOG << ss.Str();
        UNIT_ASSERT(js["host"] == "some_prefix_testing_tests_nc_users");
        UNIT_ASSERT(js["service"] == "saas_testing_tests_some-key");
        UNIT_ASSERT(js["flaps"] == flapsCanon);
        UNIT_ASSERT(js["tags"] == tagsCanon);
        UNIT_ASSERT(js["namespace"] == "ns");
        UNIT_ASSERT(js["children"][0]["service"] == "alert_name");
        UNIT_ASSERT(js["notifications"][0]["template_name"] == "on_status_change");
        UNIT_ASSERT(js["notifications"][0]["template_kwargs"]["time_end"] == "22:32");
        UNIT_ASSERT(js["notifications"][0]["template_kwargs"]["calendar_id"] == 1234567);
        UNIT_ASSERT(js["notifications"][0]["template_kwargs"]["time_start"] == "12:21");
        UNIT_ASSERT(js["notifications"][0]["template_kwargs"]["method"][0] == "phone");
        UNIT_ASSERT(js["notifications"][1]["template_name"] == "on_status_change");
        UNIT_ASSERT(js["notifications"][1]["template_kwargs"]["calendar_id"] == 1234567);
        TSet<TString> noPhoneMethods({"sms", "telegram"});
        TSet<TString> gotMethods;
        for (auto& i : js["notifications"][1]["template_kwargs"]["method"].GetArray()) {
            gotMethods.insert(i.GetString());
        }
        UNIT_ASSERT(noPhoneMethods == gotMethods);
        UNIT_ASSERT(!js["notifications"][1]["template_kwargs"].Has("time_start"));

        UNIT_ASSERT(js["notifications"][2]["template_name"] == "on_status_change");
        UNIT_ASSERT(!js["notifications"][2]["template_kwargs"].Has("calendar_id"));
        UNIT_ASSERT(js["notifications"][2]["template_kwargs"]["status"][0] == "WARN");
        TVector<TString> gotLogins;
        for (auto& i : js["notifications"][2]["template_kwargs"]["login"].GetArray()) {
            gotLogins.push_back(i.GetString());
        }
        UNIT_ASSERT(users == gotLogins);
    };
}
