#pragma once

#include "format.h"

#include <library/cpp/json/writer/json_value.h>
#include <saas/deploy_manager/config/config.h>

class TJugglerModule {
private:
    const TDeployManagerConfig::TJugglerConfig JugglerConfig;
    bool Enabled;

    bool SendJugglerRequest(const TString& query, NJson::TJsonValue& result, const TString& data="");
public:
    TJugglerModule(const TDeployManagerConfig::TAlertsConfig& alertsConfig);
    bool GetAllChecks(NJson::TJsonValue& result, const TMap<TString, TString>& filter=TMap<TString, TString>());
    bool CreateSingleCheck(const TJugglerCheck& check, const TVector<TString>& owners, NJson::TJsonValue& result);
    bool RemoveCheck(const TString& jugglerId, const TString& tag, const TString& golemHost, NJson::TJsonValue& result);
};
