#pragma once
#include <library/cpp/deprecated/atomic/atomic.h>
#include <library/cpp/json/writer/json_value.h>
#include <saas/util/cluster/slot_data.h>
#include <saas/deploy_manager/config/config.h>

class TNannyModule {
private:
    const TDeployManagerConfig::TNannyConfig NannyConfig;
    TAtomic FatalFailsCount = 0;
    TAtomic LastErrorMinutes = 0;

private:
    bool NeedFallbackToCache(const int nowMinutes);

public:
    TNannyModule(const TDeployManagerConfig::TNannyConfig& nannyConfig);

    bool GetSlots(const TString& tag, const bool useContainerNames, TVector<NRTYCluster::TSlotData>& slotsResult);
    bool GetRuntimeAttrs(const TString& tag, NJson::TJsonValue& files) const;
};
