#pragma once
#include <saas/deploy_manager/config/config.h>
#include <saas/util/cluster/slot_data.h>
#include <saas/util/network/http_request.h>
#include <library/cpp/json/writer/json_value.h>


class IRequest {
protected:
    const TDeployManagerConfig::TNannyConfig NannyConfig;

public:
    IRequest(const TDeployManagerConfig::TNannyConfig& nannyConfig);

    virtual bool Execute(NUtil::THttpReply& reply) const = 0;
    virtual bool Parse(const NUtil::THttpReply& reply) = 0;

    virtual ~IRequest() {
    }
};

class TGetSlotsRequest : public IRequest {
private:
    TString Request;
    TVector<NRTYCluster::TSlotData> SlotsResult;
    TString Tag;
    bool UseContainerNames;
    TString RawText;
public:
    static const TString SASMarker;
    static const TString MSKMarker;
    static const TString MANMarker;
    static const TString VLAMarker;

    TGetSlotsRequest(
        const TDeployManagerConfig::TNannyConfig& nannyConfig,
        const TString& tag,
        bool useContainerNames
    );

    bool Execute(NUtil::THttpReply& reply) const override;
    bool Parse(const NUtil::THttpReply& reply) override;
    bool ParseText(const TString& replyText);
    bool PutToCache();
    bool GetFromCache();
    bool DoPutToCache();
    bool DoGetFromCache();
    TString GetKey() const;

    TVector<NRTYCluster::TSlotData> GetResult() const;
};

class TGetRuntimeAttrsRequest : public IRequest {
private:
    TString Request;
    NJson::TJsonValue Result;
    TString Tag;
public:
    TGetRuntimeAttrsRequest(
        const TDeployManagerConfig::TNannyConfig& nannyConfig,
        const TString& tag
    );

    bool Execute(NUtil::THttpReply& reply) const override;
    bool Parse(const NUtil::THttpReply& reply) override;

    const NJson::TJsonValue& GetResult() const;
};


