#include "request_wizard_module.h"
#include <saas/deploy_manager/config/config.h>
#include <saas/deploy_manager/request_wizard/request_wizard.h>

TRequestWizardModule::TRequestWizardModule(const TDeployManagerConfig& config)
{
    if (config.GetRequestWizardConfig().IsInitialized()) {
        RequestWizard.Reset(new TRequestWizard(config.GetRequestWizardConfig()));
    }
}

TRequestWizardModule::~TRequestWizardModule() {
}

void TRequestWizardModule::Process(TServerRequestData& request, const TString& firstLine) const {
    if (!!RequestWizard)
        RequestWizard->Process(request, firstLine);
}
TString TRequestWizardModule::Help() const {
    if (!!RequestWizard)
        return RequestWizard->Help();
    return "";
}
