#pragma once

#include <saas/deploy_manager/storage/abstract.h>
#include <saas/library/searchmap/searchmap.h>

#include <infra/yp_service_discovery/libs/sdlib/client.h>
#include <library/cpp/json/json_writer.h>
#include <search/config/virthost.h>

class TSDModule {
private:
    const NRTYDeploy::ICommonData& EnvironmentInformation;
    const TString SDConfig;
    bool Enabled;
    TServiceDiscoveryOptions SDOptions;
    //clients
    mutable THashMap<TString, THolder<NYP::NServiceDiscovery::TSDClient>> Clients;
  //  mutable TMap<TString, TVector<TString>> SlotsByEndpointSet;

    class TProviderCallback
        : public NYP::NServiceDiscovery::IEndpointSetProvider
    {
        virtual void Update(const NYP::NServiceDiscovery::TEndpointSetEx& endpointSet) override;
    };

    class SearchMapScannerEndpointsCallback : public NSearchMapParser::ISearchMapScannerCallback {
    public:
        TSDModule& Owner;

        SearchMapScannerEndpointsCallback(TSDModule& module)
            : Owner(module) {};
        virtual void OnHost(const NSearchMapParser::TSearchMapHost& /*host*/,
            const NSearchMapParser::TSearchMapReplica& /*replica*/, const NSearchMapParser::TSearchMapService& /*service*/) override {};
        virtual void OnEndpointSet(const NSearchMapParser::TSearchMapHost& host,
            const NSearchMapParser::TSearchMapReplica& /*replica*/, const NSearchMapParser::TSearchMapService& /*service*/) override;
        virtual bool OnService(const NSearchMapParser::TSearchMapService& /*info*/) override { return true; };
    };
    void Init();
public:
    TSDModule(const TString& sdConfig, const NRTYDeploy::ICommonData& environmentInformation);
    bool AddEndpointSet(const TString& eps);
};
