#pragma once

#include <saas/deploy_manager/config/config.h>

class TServices20Module {
public:
    struct TAllocatedSlot {
        TString Host;
        ui16 SearchPort;
        ui16 BaseSearchPort;
        ui16 IndexPort;
        ui16 ControllerPort;
        TString Id;
    };
    TServices20Module(const TDeployManagerConfig& config);
    NJson::TJsonValue SendRequest(const TString& method, const TString& uri, const NJson::TJsonValue* data) const;
    TSet<TString> GetSerivesList() const;
    void CreateSevice(const TString& name) const;
    void SetServiceAttrs(const TString& name) const;
    TAllocatedSlot CreateOneSlotAllocation(const TString& datacenterAlias, const TString& service, const TString& ctype) const;
    void RemoveAllocation(const TString& id, const TString& service) const;
    void Deploy(const TString& service) const;
    bool CheckDeployComplite(const TString& service, const TString& id) const;
private:
    void PutDataWithSnapshotId(const TString& uri, NJson::TJsonValue& data) const;
    void SetServiceAttrsInfo(const TString& name) const;
    void SetServiceAttrsAuth(const TString& name) const;
    void SetServiceAttrsRuntime(const TString& name) const;
    TString Host;
    ui16 Port;
    TString Uri;
    TString Token;
    TDeployManagerConfig::TServices20Config::TClustersByCType ClustersByCType;
};
