#pragma once

#include <saas/deploy_manager/request_wizard/request_wizard_config.pb.h>

#include <library/cpp/http/misc/httpreqdata.h>
#include <util/generic/set.h>
#include <util/generic/map.h>
#include <util/string/vector.h>
#include <util/folder/path.h>

class TServerRequestData;

class TRequestWizard {
public:
    void Process(TServerRequestData& request, const TString& firstLine) const;
    TString Help() const;

private:
    class TRule {
    public:
        TRule(const NRTYRequestWizard::TRule& cfg);
        bool Process(TServerRequestData& request) const;
        bool operator < (const TRule& other) const;
        TString ToString(const TString& method) const;
    private:
        TVector<TString> FixedUriPart;
        TVector<TString> VariableUriPart;
        struct TCgi {
            TCgi(const char* value);
            bool Required;
            TString DefValue;
        };
        TMap<TString, TCgi> Cgi;
        TString Result;
    };

    typedef TSet<TRule> TRules;
    typedef TMap<TString, TRules> TRulesByMethod;
    TRulesByMethod Rules;

public:
    class TRequestWizardConfig {
    public:
        TRequestWizardConfig();
        void Init(const TString& rwc);
        void InitFromString(const TString& text);
        TString ToString() const;
        bool IsInitialized() const;

        TMap<TString, TSet<TRule>> Rules;

    private:
        TFsPath RequestWizardConfigPath;
    };


    TRequestWizard(const TRequestWizardConfig& config);
};
