#include "action.h"

#include <library/cpp/logger/global/global.h>

#include <library/cpp/json/writer/json_value.h>
#include <library/cpp/json/json_reader.h>

#include <util/stream/str.h>

namespace NRTYDeploy {
    NJson::TJsonValue TAddIntSearchAction::DoSerializeToJson() const {
        NJson::TJsonValue result;
        result.InsertValue("slots_allocator", SlotsAllocator.SerializeToJson());
        result.InsertValue("ctype", CType);
        result.InsertValue("service", Service);
        result.InsertValue("count_replicas", CountReplicas);
        result.InsertValue("count_shards", CountShards);
        result.InsertValue("pool", Pool.Serialize());
        return result;
    }

    void TAddIntSearchAction::DoDeserializeFromJson(const NJson::TJsonValue& json) {
        NJson::TJsonValue::TMapType map;
        CHECK_WITH_LOG(json.GetMap(&map));
        CHECK_WITH_LOG(SlotsAllocator.DeserializeFromJson(map["slots_allocator"]));
        CType = map["ctype"].GetStringRobust();
        Service = map["service"].GetStringRobust();
        CountShards = map["count_shards"].GetIntegerRobust();
        CountReplicas = map["count_replicas"].GetIntegerRobust();
        Pool.DeserializeFromJson(map["pool"]);
    }

    TAddIntSearchAction::TFactory::TRegistrator<TAddIntSearchAction> TAddIntSearchAction::Registrator(ADD_INTSEARCH_ACTION_NAME);
}
