#include "task.h"
#include "script.h"

#include <saas/deploy_manager/scripts/cluster/cluster_task.h>
#include <saas/deploy_manager/scripts/common/scripts_helper.h>
#include <saas/deploy_manager/scripts/common/slots_allocator/allocator.h>
#include <saas/deploy_manager/server/client/client.h>
#include <library/cpp/logger/global/global.h>

#include <library/cpp/json/json_writer.h>

#include <util/stream/str.h>
#include <util/charset/utf8.h>
#include <util/charset/wide.h>

namespace NRTYDeploy {

    TClusterTask::TPtr TScriptAddIntSearch::DoBuildTask(IDeployInfoRequest& request) const {
        const auto& cgi = request.GetRD().CgiParam;
        ui32 replicasCount = FromString<ui32>(cgi.Get("count_replicas"));
        ui32 shardsCount = FromString<ui32>(cgi.Get("count_shards"));
        NRTYCluster::TSlotsAllocator sa;
        if (!sa.DeserializeFromString(cgi.Get("slots_allocator"))) {
            request.Output() << "HTTP/1.1 400 \r\n\r\n";
            request.Output() << "Incorrect cgi slots allocator description";
            return nullptr;
        }
        TClusterTask::TCgiContext context = TClusterTask::TCgiContext::Parse(cgi, INT_SERVICE);

        return new TAddIntSearchTask(sa, context, &request, shardsCount, replicasCount);
    };

    IScript::TFactory::TRegistrator<TScriptAddIntSearch> TScriptAddIntSearch::Registrator("add_intsearch");
}
