#pragma once

#include <saas/deploy_manager/scripts/cluster/cluster_task.h>
#include <saas/deploy_manager/scripts/common/scripts_helper.h>
#include <saas/deploy_manager/scripts/common/script.h>
#include <saas/deploy_manager/scripts/common/slots_allocator/allocator.h>
#include <saas/library/daemon_base/actions_engine/controller_script.h>
#include <util/thread/pool.h>

#define ADD_INTSEARCH_TASK_TYPE "ADD_INTSEARCH_TASK"

namespace NRTYDeploy {

    class TAddIntSearchTask : public TClusterTask {
    private:
        NRTYCluster::TSlotsAllocator SlotsAllocator;
        NSearchMapParser::TSlotsPool Pool;
        ui32 ReplicasCount;
        ui32 ShardsCount;
    public:
        TAddIntSearchTask(const NRTYCluster::TSlotsAllocator& slotsAllocator, const TClusterTask::TCgiContext& context, NRTYDeploy::ICommonData* commonData, ui32 shardsCount, ui32 replicasCount = 1);
        virtual void DoBuildTask();
        TString GetReportConstruction() const;
    };

}
