#include "action.h"

#include <library/cpp/json/json_reader.h>
#include <library/cpp/json/writer/json_value.h>
#include <library/cpp/logger/global/global.h>
#include <util/stream/str.h>

namespace NDaemonController {
    NJson::TJsonValue TAddReplicaAction::DoSerializeToJson() const {
        NJson::TJsonValue result;
        result.InsertValue("slots_count", SlotsCount);
        result.InsertValue("ctype", CType);
        result.InsertValue("service", Service);
        result.InsertValue("service_type", ServiceType);
        result.InsertValue("slots_allocator", SlotsAllocator.SerializeToJson());
        result.InsertValue("count_replicas", CountReplicas);
        result.InsertValue("pool", Pool.Serialize());
        result.InsertValue("restore", Restore);
        result.InsertValue("allocate_only", AllocateOnly);
        result.InsertValue("deploy_proxy", DeployProxy);
        result.InsertValue("may_be_dead_interval_percentage", (double)MayBeDeadIntervalPercentage);
        return result;
    }

    void TAddReplicaAction::DoDeserializeFromJson(const NJson::TJsonValue& json) {
        CHECK_WITH_LOG(json.IsMap());
        SlotsCount = json["slots_count"].GetIntegerRobust();
        CType = json["ctype"].GetStringRobust();
        Service = json["service"].GetStringRobust();
        ServiceType = json["service_type"].GetStringRobust();
        CHECK_WITH_LOG(SlotsAllocator.DeserializeFromJson(json["slots_allocator"]));
        CountReplicas = json["count_replicas"].GetIntegerRobust();
        Restore = json["restore"].GetBooleanRobust();
        AllocateOnly = json["allocate_only"].GetBooleanRobust();
        Pool.DeserializeFromJson(json["pool"]);
        DeployProxy = json["deploy_proxy"].GetBooleanRobust();
        MayBeDeadIntervalPercentage = (float)json["may_be_dead_interval_percentage"].GetDoubleRobust();
    }

    TAddReplicaAction::TFactory::TRegistrator<TAddReplicaAction> TAddReplicaAction::Registrator(ADD_REPLICA_ACTION_NAME);
}
