#pragma once
#include <saas/deploy_manager/scripts/cluster/cluster_task.h>
#include <saas/deploy_manager/scripts/common/scripts_helper.h>
#include <saas/deploy_manager/scripts/common/script.h>
#include <saas/deploy_manager/scripts/common/slots_allocator/allocator.h>
#include <saas/library/daemon_base/actions_engine/controller_script.h>
#include <util/thread/pool.h>

#define ADD_REPLICA_TASK_TYPE "ADD_REPLICA_TASK"

namespace NRTYDeploy {

    class TAddReplicaTask : public TClusterTask {
    private:
        NRTYCluster::TSlotsAllocator SlotsAllocator;
        ui32 SlotsCount;
        ui32 ReplicasCount;
        bool Restore;
        bool AllocateOnly;
        bool DeployProxy;
        float MayBeDeadIntervalPercentage;
    public:
        TAddReplicaTask(ui32 slotsCount, const NRTYCluster::TSlotsAllocator& slotsAllocator, const TClusterTask::TCgiContext& context,
            NRTYDeploy::ICommonData* commonData, ui32 replicasCount = 1,
            bool restore = true, bool allocateOnly = false, bool deployProxy = true, float mayBeDeadIntervalPercentage = 0.01f);

        virtual void DoBuildTask() override;
        TString GetReportConstruction() const;
    };

}
