#include "action.h"

#include <library/cpp/json/writer/json_value.h>
#include <library/cpp/json/json_reader.h>
#include <library/cpp/logger/global/global.h>
#include <util/stream/str.h>

namespace NDaemonController {

    void TActivateSlotsAction::AddPrevActionsResult(const NRTYScript::ITasksInfo& info) {
        if (Slots.StartsWith('$')) {
            TString path = Slots.substr(1);
            NJson::TJsonValue result;
            if (info.GetValueByPath(path, result) && !!result.GetStringRobust()) {
                NSearchMapParser::TSlotsPool pool;
                if (!pool.DeserializeFromString(result.GetStringRobust()))
                    Fail("Incorrect task info: " + result.GetStringRobust() + " / " + path);
                else
                    Slots = pool.Serialize().GetStringRobust();
            } else {
                DEBUG_LOG << "Incorrect extract data path " << path << Endl;
            }
        }
    }

    NJson::TJsonValue TActivateSlotsAction::DoSerializeToJson() const {
        NJson::TJsonValue result;
        result.InsertValue("slots", Slots);
        result.InsertValue("ctype", CType);
        result.InsertValue("service", Service);
        result.InsertValue("service_type", ServiceType);
        return result;
    }

    void TActivateSlotsAction::DoDeserializeFromJson(const NJson::TJsonValue& json) {
        CHECK_WITH_LOG(json.IsMap());
        Slots = json["slots"].GetStringRobust();
        CType = json["ctype"].GetStringRobust();
        Service = json["service"].GetStringRobust();
        ServiceType = json["service_type"].GetStringRobust();
    }

    TActivateSlotsAction::TFactory::TRegistrator<TActivateSlotsAction> TActivateSlotsAction::Registrator(ACTIVATE_SLOTS_ACTION_NAME);
}
