#pragma once
#include <saas/deploy_manager/scripts/cluster/cluster_task.h>
#include <saas/library/daemon_base/actions_engine/controller_client.h>
#include <saas/library/searchmap/searchmap.h>
#include <saas/library/searchmap/slots_pool.h>
#include <util/string/vector.h>

#define ACTIVATE_SLOTS_ACTION_NAME "ACTIVATE_SLOTS"

namespace NDaemonController {

    class TActivateSlotsAction : public NRTYDeploy::TClusterAsyncAction {
    private:
        TString Slots;
        TString CType;
        TString Service;
        TString ServiceType;
    protected:

        virtual NJson::TJsonValue DoSerializeToJson() const override;
        virtual void DoDeserializeFromJson(const NJson::TJsonValue& json) override;

        virtual TString GetCustomUriStart() const override {
            return "activate_slots";
        }

        virtual TString DoBuildCommandStart() const override {
            return "slots=" + Slots +
                "&ctype=" + CType + "&service=" + Service + "&service_type=" + ServiceType;
        }

        virtual void AddPrevActionsResult(const NRTYScript::ITasksInfo& info) override;

        static TFactory::TRegistrator<TActivateSlotsAction> Registrator;
    public:

        TActivateSlotsAction() {}

        TActivateSlotsAction(const TString& slots, const TString& ctype, const TString& service, const TString& serviceType)
            : TClusterAsyncAction(apStartAndWait)
            , Slots(slots)
            , CType(ctype)
            , Service(service)
            , ServiceType(serviceType)
        {}

        virtual TString ActionName() const override { return ACTIVATE_SLOTS_ACTION_NAME; }
    };
}
