#include "script.h"
#include <saas/deploy_manager/server/client/client.h>
#include <saas/deploy_manager/scripts/common/scripts_helper.h>
#include "task.h"

namespace NRTYDeploy {

    TClusterTask::TPtr TScriptActivateSlots::DoBuildTask(IDeployInfoRequest& request) const {
        const TCgiParameters& cgi = request.GetRD().CgiParam;

        TClusterTask::TCgiContext context = TClusterTask::TCgiContext::Parse(cgi);

        if (!context.Service) {
            request.Output() << "HTTP/1.1 400 \r\n\r\n";
            request.Output() << "service does not set";
            return nullptr;
        }

        if (!context.CType) {
            request.Output() << "HTTP/1.1 400 \r\n\r\n";
            request.Output() << "ctype does not set";
            return nullptr;
        }

        NSearchMapParser::TSlotsPool slotsPool;
        if (!slotsPool.DeserializeFromString(cgi.Get("slots"))) {
            request.Output() << "HTTP/1.1 400 \r\n\r\n";
            request.Output() << "slots does not set";
            return nullptr;
        }

        return new TActivateSlotsTask(slotsPool, context, &request);
    }

    IScript::TFactory::TRegistrator<TScriptActivateSlots> TScriptActivateSlots::Registrator("activate_slots");
}
